/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPoint.h,v 1.2 1999/09/17 04:20:48 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CPoint_h	// [
#define Included_CPoint_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CPoint

class CPoint
{
public:
	CPoint(LONG x = 0, LONG y = 0);
	CPoint(POINT point);

	operator POINT&() {return mPoint;}
	operator const POINT&() const {return mPoint;}

	operator POINT *() {return &mPoint;}
	operator const POINT *() const {return &mPoint;}

	operator SIZE *()
	{
		return reinterpret_cast<SIZE *>(&mPoint);
	}

	operator const SIZE *() const
	{
		return reinterpret_cast<const SIZE *>(&mPoint);
	}

	const LONG&	X() const {return mPoint.x;}
	LONG&		X() {return mPoint.x;}

	const LONG&	Y() const {return mPoint.y;}
	LONG&		Y() {return mPoint.y;}

	void		Reset();

private:
	POINT	mPoint;
};


// Class CPoint member functions

inline 
CPoint::CPoint(LONG x, LONG y)
{
	mPoint.x = x;
	mPoint.y = y;
}

inline 
CPoint::CPoint(POINT point)
{
	mPoint = point;
}

inline 
void 
CPoint::Reset()
{
	mPoint.x = mPoint.y = 0;
}

_PGP_END

#endif	// ] Included_CPoint_h
